<div class="wrap">
    <h1>RDW Auto Info</h1>
	<?php
	if (function_exists('rdw_get_license_key') && function_exists('rdw_validate_license_remote')) {
		$key = rdw_get_license_key();
		if (!empty($key)) {
			rdw_validate_license_remote($key);
		}
	}
	?>
    <?php
	$status = function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()
		? 'Pro licentie is actief'
		: 'Gratis versie (niet online plaatsen, geen foto’s). Neem contact op: contact@onlineja.nl';

    echo '<div style="float:right; font-weight:bold; color:#0073aa;">Licentie: ' . esc_html($status) . '</div>';

    // Add product link button (if no Pro active)
	if (!function_exists('rdw_is_pro_enabled') || !rdw_is_pro_enabled()) {
		echo '<div style="float:right; clear:right; margin-top:6px;">'
		   . '<a href="' . esc_url('https://onlineja.nl/product/rdw-licentie/') . '" target="_blank" rel="noopener" class="button button-primary">'
		   . 'Bestel RDW Licentie'
		   . '</a></div>';
	}
    ?>
		<?php
		// Handle save of instructions
		if (isset($_POST['rdw_save_notes']) && check_admin_referer('rdw_notes_action','rdw_notes_nonce')) {
			$notes = wp_kses_post( wp_unslash( $_POST['rdw_notes'] ?? '' ) );
			update_option('rdw_auto_info_notes', $notes, false);
			echo '<div class="notice notice-success"><p>Instructies opgeslagen.</p></div>';
		}

		// Get current notes
		$current_notes = get_option('rdw_auto_info_notes', '');
		?>

		<h2>Instructies / Notities</h2>
		<form method="post" action="">
			<?php wp_nonce_field('rdw_notes_action','rdw_notes_nonce'); ?>
			<textarea name="rdw_notes" rows="6" style="width:100%;"><?php echo esc_textarea($current_notes); ?></textarea>
			<p><input type="submit" name="rdw_save_notes" class="button button-primary" value="Opslaan"></p>
		</form>

    <!-- Zoekformulier -->
	<form method="post" action="<?php echo esc_url(admin_url('admin.php?page=rdw-auto-info')); ?>" style="display: flex; gap: 10px; align-items: center;">
		<input type="text" name="kenteken" placeholder="RDW kenteken zoeken" class="regular-text">
		<input type="text" name="zoek_veld" placeholder="Zoek opgeslagen auto's..." class="regular-text">
		<?php wp_nonce_field('rdw_search_kenteken','rdw_nonce_search'); ?>
		<input type="submit" value="Zoeken" class="button button-primary">
	</form>

    <?php
    global $wpdb;
    $table_name = $wpdb->prefix . "rdw_auto_info";

    // Dupliceer actie
    if (isset($_GET['rdw_duplicate'])) {
        if (!current_user_can('edit_posts')) {
            echo '<div class="notice notice-error"><p>Geen toestemming om te dupliceren.</p></div>';
        } else {
            $dup_id = intval( wp_unslash( $_GET['rdw_duplicate'] ?? 0 ) );
            if ($dup_id > 0 && function_exists('rdw_duplicate_entry')) {
                $new_id = rdw_duplicate_entry($dup_id);
                if ($new_id) {
                    echo '<div class="notice notice-success is-dismissible"><p>Regel gedupliceerd. Nieuw ID: ' . intval($new_id) . '</p></div>';
                } else {
                    echo '<div class="notice notice-error is-dismissible"><p>Dupliceren mislukt (ID niet gevonden of insert faalde).</p></div>';
                }
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>Ongeldige duplicatie-actie.</p></div>';
            }
        }
    }

    // Veldenlijst
    $verkoopgegevens = [
        'kenteken','voertuigsoort','merk','handelsbenaming','vervaldatum_apk','inrichting',
        'aantal_zitplaatsen','eerste_kleur','aantal_cilinders','cilinderinhoud',
        'massa_ledig_voertuig','toegestane_maximum_massa_voertuig','massa_rijklaar',
        'datum_eerste_toelating','datum_eerste_tenaamstelling_in_nederland','catalogusprijs',
        'aantal_deuren','lengte','tellerstandoordeel','brandstof_omschrijving',
        'brandstofverbruik_buiten','brandstofverbruik_gecombineerd','brandstofverbruik_stad',
        'co2_uitstoot_gecombineerd','uitlaatemissieniveau','type_carrosserie_europese_omschrijving',
        'maximum_massa_trekken_ongeremd','maximum_trekken_massa_geremd'
    ];

    // Zoekactie
	if (
		isset($_POST['kenteken'], $_POST['rdw_nonce_search']) &&
		wp_verify_nonce( wp_unslash( $_POST['rdw_nonce_search'] ), 'rdw_search_kenteken' )
	) {
		$kenteken_raw = wp_unslash( $_POST['kenteken'] );
		$kenteken     = strtoupper( sanitize_text_field( $kenteken_raw ) );
        $rdw_endpoints = [
            "https://opendata.rdw.nl/resource/m9d7-ebf2.json?kenteken=$kenteken",
            "https://opendata.rdw.nl/resource/8ys7-d773.json?kenteken=$kenteken",
            "https://opendata.rdw.nl/resource/vezc-m2t6.json?kenteken=$kenteken"
        ];

        $data = [];
        foreach ($rdw_endpoints as $endpoint) {
            $response = wp_remote_get($endpoint);
            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response), true);
                if (!empty($body)) {
                    foreach ($verkoopgegevens as $field) {
                        if (!isset($data[$field])) {
                            foreach ($body as $row) {
                                if (isset($row[$field]) && $row[$field] !== '') {
                                    $data[$field] = $row[$field];
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }

        if (!empty($data)) : ?>
            <h2>Autogegevens</h2>
            <form method="post" action="<?php echo esc_url( admin_url('admin.php?page=rdw-auto-info') ); ?>" class="rdw-form" enctype="multipart/form-data">
                <?php wp_nonce_field('rdw_save_selected','rdw_nonce_save'); ?>

                <button type="button" id="select-all-new" class="button">Selecteer alles</button>
                <button type="button" id="deselect-all-new" class="button">Deselecteer alles</button><br><br>

                <input type="hidden" name="kenteken" value="<?php echo esc_attr($kenteken); ?>">

                <label for="kilometers">Kilometers:</label>
                <input type="text" name="kilometers" id="kilometers" class="regular-text"><br><br>

                <label for="prijs">Prijs:</label>
                <input type="text" name="prijs" id="prijs" class="regular-text"><br><br>
				
				<label for="verkoper_tekst">Verkoperstekst:</label>
				<textarea name="verkoper_tekst" id="verkoper_tekst" rows="4" class="large-text"></textarea><br><br>
				
				<?php if (function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()) : ?>
					<label>Uitgelichte foto:</label>
					<input type="hidden" name="featured_photo_id" id="featured_photo_id">
					<button type="button" class="button" id="select-featured-photo">Kies uit Media Bibliotheek</button>
					<div id="featured-photo-preview"></div><br>

					<label>Galerijfoto's:</label>
					<input type="hidden" name="gallery_photo_ids" id="gallery_photo_ids">
					<button type="button" class="button" id="select-gallery-photos">Kies meerdere uit Media Bibliotheek</button>
					<div id="gallery-photos-preview"></div><br>
					<?php else: ?>
						<div class="notice notice-info" style="margin-top:10px;">
							<p>Foto’s uploaden en berichten aanmaken zijn Pro-functionaliteiten. Activeer je licentie om deze functies te gebruiken.</p>
							<p>
								<a href="<?php echo esc_url('https://onlineja.nl/product/rdw-licentie/'); ?>" target="_blank" class="button button-primary">
									Bestel RDW Licentie
								</a>
							</p>
						</div>
					<?php endif; ?>
                <ul id="new-vehicle-data">
                    <?php foreach ($data as $key => $value): ?>
                        <li>
                            <input type="checkbox" name="selected_data[]" value="<?php echo esc_attr($key); ?>" checked>
                            <strong><?php echo esc_html(ucfirst(str_replace('_', ' ', $key))); ?>:</strong>
                            <input type="text" name="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($value); ?>" readonly>
                        </li>
                    <?php endforeach; ?>
                </ul>

                <input type="submit" name="save_selected_data" value="Sla selectie op" class="button button-primary">
            </form>
		<?php else: ?>
		<?php if (!empty($_POST['kenteken'])): ?>
			<div class="notice notice-warning">
				<p>⚠️ <?php echo esc_html__('Geen gegevens gevonden voor kenteken:', 'rdw-auto-info'); ?>
					<strong><?php echo esc_html( strtoupper( sanitize_text_field( wp_unslash($_POST['kenteken']) ) ) ); ?></strong>
				</p>
			</div>
		<?php endif; ?>
		<?php endif;
		}

    // Opslaan nieuwe data (enkelvoudig, correct)
	if (
		isset($_POST['save_selected_data'], $_POST['rdw_nonce_save']) &&
		wp_verify_nonce( wp_unslash($_POST['rdw_nonce_save']), 'rdw_save_selected' )
	) {
		$kenteken = strtoupper( sanitize_text_field( wp_unslash($_POST['kenteken'] ?? '') ) );
		$selected_fields = array_map( 'sanitize_key', (array) wp_unslash( $_POST['selected_data'] ?? [] ) );
		$selected_data = [];

		foreach ($selected_fields as $field) {
			if (isset($_POST[$field])) {
				$selected_data[$field] = sanitize_text_field( wp_unslash($_POST[$field]) );
			}
		}

		$selected_data['kilometers']     = rdw_format_kilometers( wp_unslash($_POST['kilometers'] ?? '') );
		$selected_data['prijs']          = sanitize_text_field( wp_unslash($_POST['prijs'] ?? '') );
		$selected_data['verkoper_tekst'] = sanitize_textarea_field( wp_unslash($_POST['verkoper_tekst'] ?? '') );
				
		$serialized_data = maybe_serialize($selected_data);
        $current_user_id = get_current_user_id();

        $wpdb->insert($table_name, [
				'kenteken'   => $kenteken,
				'data'       => $serialized_data,
				'created_by' => $current_user_id,
				'updated_by' => $current_user_id,
				'created_at' => current_time('mysql'),
				'updated_at' => current_time('mysql')
			]);

			$new_vehicle_id = $wpdb->insert_id;
			
			$bouwjaar = !empty($selected_data['datum_eerste_toelating'])
				? gmdate('Y', strtotime($selected_data['datum_eerste_toelating']))
				: null;

			$prijs_decimal = null;
			if (!empty($selected_data['prijs'])) {
				$prijs_decimal = floatval(str_replace(',', '.', str_replace('.', '', $selected_data['prijs'])));
			}

			$wpdb->update($table_name, [
				'merk'            => $selected_data['merk'] ?? null,
				'handelsbenaming' => $selected_data['handelsbenaming'] ?? null,
				'bouwjaar'        => $bouwjaar,
				'prijs'           => $prijs_decimal,
			], ['id' => $new_vehicle_id]);
			
			// Save featured + gallery photo IDs
			$featured_id = intval( wp_unslash( $_POST['featured_photo_id'] ?? 0 ) );
			$gallery_raw = wp_unslash( $_POST['gallery_photo_ids'] ?? '' );
			$gallery_ids = array_filter( array_map('intval', explode(',', $gallery_raw)) );

			// Save featured + gallery photo IDs (Pro only)
			if (function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()) {
				if ($featured_id) {
					update_option('rdw_vehicle_featured_' . $new_vehicle_id, $featured_id, false);
				}
				if ($gallery_ids) {
					update_option('rdw_vehicle_gallery_' . $new_vehicle_id, $gallery_ids, false);
				}
			}

			echo '<div class="notice notice-success"><p>Geselecteerde gegevens zijn opgeslagen.</p></div>';
    }

    // Update bestaande data (enkelvoudig, correct)
		if (
			isset($_POST['rdw_nonce_update'], $_POST['update_selected_data']) &&
			wp_verify_nonce( wp_unslash($_POST['rdw_nonce_update']), 'rdw_update_selected' )
		) {
			$id  = intval( wp_unslash($_POST['id'] ?? 0) );
			$row = $wpdb->get_row( $wpdb->prepare("SELECT * FROM {$table_name} WHERE id = %d", $id) );
			// ...
			$selected_fields = array_map( 'sanitize_key', (array) wp_unslash( $_POST['selected_data'] ?? [] ) );
			// ...
			$selected_data['kilometers']     = rdw_format_kilometers( wp_unslash($_POST['kilometers'] ?? ($data['kilometers'] ?? '')) );
			$selected_data['prijs']          = sanitize_text_field( wp_unslash($_POST['prijs'] ?? ($data['prijs'] ?? '')) );
			$selected_data['verkoper_tekst'] = sanitize_textarea_field( wp_unslash($_POST['verkoper_tekst'] ?? ($data['verkoper_tekst'] ?? '')) );
			$selected_data['verkocht']       = !empty($_POST['verkocht']) ? '1' : '0';

        $wpdb->update($table_name, [
            'data'       => maybe_serialize($selected_data),
            'updated_by' => get_current_user_id(),
            'updated_at' => current_time('mysql')
        ], ['id' => $id]);
		
		$kenteken = sanitize_text_field( wp_unslash($_POST['kenteken'] ?? '') );
		if (!empty($row->post_id)) {
			$post = get_post($row->post_id);
			if ($post && $post->post_type === 'post') {
				$current_title = $post->post_title;

				if (!empty($_POST['verkocht']) && $_POST['verkocht'] === '1') {
					if (!preg_match('/^Verkocht!\s/i', $current_title)) {
						$new_title = 'Verkocht! ' . $current_title;
						wp_update_post([
							'ID'         => $post->ID,
							'post_title' => $new_title
						]);
					}
				} else {
					if (stripos($current_title, 'verkocht!') === 0) {
						$new_title = trim(preg_replace('/^Verkocht!\s*/i', '', $current_title));
						wp_update_post([
							'ID'         => $post->ID,
							'post_title' => $new_title
						]);
					}
				}
			}
		}
		
		// Foto's opslaan
		$featured_id = intval( wp_unslash( $_POST['featured_photo_id'] ?? 0 ) );
		$gallery_raw = wp_unslash( $_POST['gallery_photo_ids'] ?? '' );
		$gallery_ids = array_filter( array_map('intval', explode(',', $gallery_raw)) );

		if (function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()) {
			if ($featured_id) {
				update_option('rdw_vehicle_featured_' . $id, $featured_id, false);
			} else {
				delete_option('rdw_vehicle_featured_' . $id);
			}

			if (!empty($gallery_ids)) {
				update_option('rdw_vehicle_gallery_' . $id, $gallery_ids, false);
			} else {
				delete_option('rdw_vehicle_gallery_' . $id);
			}
		}		

        echo '<div class="notice notice-success"><p>Gegevens bijgewerkt.</p></div>';
    }

    // Verwijderen
	if (
		isset($_POST['delete_vehicle'], $_POST['rdw_nonce_delete']) &&
		$_POST['delete_vehicle'] === '1' &&
		wp_verify_nonce( wp_unslash($_POST['rdw_nonce_delete']), 'rdw_delete_vehicle' )
	) {
		$wpdb->delete($table_name, ['id' => intval( wp_unslash($_POST['id'] ?? 0) )]);
		echo '<div class="notice notice-success"><p>' . esc_html__('Voertuig verwijderd.', 'rdw-auto-info') . '</p></div>';
	}

    // Bericht maken
		if (
			isset($_POST['create_post'], $_POST['rdw_nonce_create']) &&
			$_POST['create_post'] === '1' &&
			wp_verify_nonce( wp_unslash($_POST['rdw_nonce_create']), 'rdw_create_post' )
		) {

		if (!function_exists('rdw_is_pro_enabled') || !rdw_is_pro_enabled()) {
			echo '<div class="notice notice-error"><p>Pro-licentie vereist om een bericht aan te maken.</p></div>';
			// Stop further processing
			return;
		}
        $id  = intval( wp_unslash($_POST['id'] ?? 0) );
		$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$table_name} WHERE id = %d", $id) );
        if ($row) {
            $data = maybe_unserialize($row->data);
            $bouwjaar = !empty($data['datum_eerste_toelating'])? gmdate('Y', strtotime($data['datum_eerste_toelating'])): 'N/A';

			$post_title = sprintf('%s - %s - KM: %s - € %s - %s',
				esc_html($data['merk'] ?? 'N/A'),
				esc_html($data['handelsbenaming'] ?? 'N/A'),
				esc_html($data['kilometers'] ?? 'N/A'),
				esc_html($data['prijs'] ?? 'N/A'),
				esc_html($bouwjaar)
			);

			if (!empty($data['verkocht']) && $data['verkocht'] === '1') {
				$post_title = 'Verkocht! ' . $post_title;
			}

			$post_content = '';

			// Verkoperstekst
			if (!empty($data['verkoper_tekst'])) {
				$post_content .= '<div class="verkoper-tekst">' . wpautop(esc_html($data['verkoper_tekst'])) . '</div>';
			}

			// Kilometers
			$post_content .= '<p><strong>Kilometers:</strong> ' . esc_html($data['kilometers'] ?? 'N/A') . '</p>';
			// Prijs
			$post_content .= '<p><strong>Prijs:</strong> ' . esc_html($data['prijs'] ?? 'N/A') . '</p>';
			foreach ($data as $key => $value) {
				if (!in_array($key, ['kilometers','prijs','verkoper_tekst','verkocht'])) {
					$post_content .= '<p><strong>' . ucfirst(str_replace('_',' ',$key)) . ':</strong> ' . esc_html($value) . '</p>';
				}
			}

            $post_id = wp_insert_post([
				'post_title'   => $post_title,
				'post_content' => $post_content,
				'post_status'  => 'publish',
				'post_type'    => 'post'
			]);
			
			if ($post_id) {
				update_post_meta($post_id, '_rdw_kenteken', $row->kenteken);
				$wpdb->update($table_name, ['post_id' => $post_id], ['id' => $id]);

				// Uitgelichte foto
				$featured_id = get_option('rdw_vehicle_featured_' . $id);
				if ($featured_id) {
					set_post_thumbnail($post_id, $featured_id);
				}

				// Galerijfoto's als WordPress gallery shortcode (compatibel grid + klikbaar)
				$gallery_ids = get_option('rdw_vehicle_gallery_' . $id);
				if (is_array($gallery_ids) && !empty($gallery_ids)) {
					$ids_attr = implode(',', array_map('intval', $gallery_ids));

					// Gallery shortcode parameters:
					// columns: aantal kolommen in de grid
					// size: weergavegrootte per item (thumbnail/medium/large/full)
					// link: 'file' (voor lightbox), 'post' (naar attachment), of 'none'
					$gallery_shortcode = '[gallery ids="' . $ids_attr . '" columns="3" size="medium" link="file"]';

					$new_content = $gallery_shortcode . "\n\n" . $post_content;

					wp_update_post([
						'ID'           => $post_id,
						'post_content' => $new_content,
					]);
				}

				echo '<div class="notice notice-success"><p>Auto is online gezet: <a href="' . esc_url(get_permalink($post_id)) . '" target="_blank">🌐 Bekijk online</a></p></div>';
			} else {
				echo '<div class="notice notice-error"><p>Fout bij online zetten van de auto.</p></div>';
			}
        }
    }

    // Bulk delete
		if (
			isset($_POST['bulk_delete_submit'], $_POST['rdw_nonce_bulk']) &&
			wp_verify_nonce( wp_unslash($_POST['rdw_nonce_bulk']), 'rdw_bulk_delete' )
		) {
			$ids = array_map('intval', (array) wp_unslash( $_POST['bulk_delete'] ?? [] ));
			$ids = array_filter($ids, fn($v) => $v > 0);
			if ( $ids ) {
				$placeholders = implode( ',', array_fill( 0, count( $ids ), '%d' ) );
				$wpdb->query(
					$wpdb->prepare(
						"DELETE FROM {$table_name} WHERE id IN ($placeholders)",
						...$ids
					)
				);
				echo '<div class="notice notice-success"><p>' . esc_html__('Geselecteerde voertuigen verwijderd.', 'rdw-auto-info') . '</p></div>';
			} else {
				echo '<div class="notice notice-warning"><p>' . esc_html__('Geen voertuigen geselecteerd.', 'rdw-auto-info') . '</p></div>';
			}
		}
    ?>

    <?php
    // Resultaten tabel (enkelvoudig, volledig)
	$zoekterm = isset($_POST['zoek_veld']) ? strtoupper( sanitize_text_field( wp_unslash($_POST['zoek_veld']) ) ) : '';
	if ($zoekterm) {
		$like = '%' . $wpdb->esc_like($zoekterm) . '%';
		$results = $wpdb->get_results( $wpdb->prepare("
			SELECT * FROM $table_name
			WHERE kenteken LIKE %s
			   OR merk LIKE %s
			   OR handelsbenaming LIKE %s
			   OR CAST(bouwjaar AS CHAR) LIKE %s
			   OR CAST(prijs AS CHAR) LIKE %s
			   OR data LIKE %s
		", $like, $like, $like, $like, $like, $like) );
	} else {
		$results = $wpdb->get_results("SELECT * FROM $table_name");
	}
    if (!empty($results)) : ?>
	
		<?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
			<?php if (empty($results)): ?>
				<div class="notice notice-warning"><p>⚠️ Geen resultaten gevonden.</p></div>
			<?php elseif (empty($data) && !empty($_POST['zoek_veld'])): ?>
				<div class="notice notice-info"><p>🔍 <?php echo esc_html( (string) count($results) ); ?> resultaat<?php echo (count($results) > 1 ? 'en' : ''); ?> gevonden.</p></div>
			<?php endif; ?>
		<?php endif; ?>

        <h2>Opgeslagen Auto's (<?php echo esc_html( count($results) ); ?>)</h2>
        <form method="post" action="<?php echo esc_url( admin_url('admin.php?page=rdw-auto-info') ); ?>" id="bulk-delete-form">
            <?php wp_nonce_field('rdw_bulk_delete','rdw_nonce_bulk'); ?>
            <div class="table-wrapper">
			<table class="wp-list-table widefat fixed striped">
				<thead>
					<tr>
						<th class="manage-column column-cb check-column" data-sort="none">
							<input type="checkbox" id="select-all" title="Selecteer/Deselecteer alles">
						</th>
						<th data-sort="none">Acties</th>
						<th data-sort="text">Kenteken</th>
						<th data-sort="text">Merk</th>
						<th data-sort="text">Model</th>
						<th data-sort="text">Verkocht</th>
						<th data-sort="text">Online?</th>
						<th data-sort="number">Foto's</th>
						<th data-sort="text">Kilometers</th>
						<th data-sort="number">Prijs</th>
						<th data-sort="number">Bouwjaar</th>
						<th data-sort="date">Aangemaakt op</th>
						<th data-sort="date">Bewerkt op</th>
						<th data-sort="text">Aangemaakt door</th>
						<th data-sort="text">Bewerkt door</th>
					</tr>
				</thead>
                <tbody>
                    <?php foreach ($results as $row):
                        $data = maybe_unserialize($row->data);
                        $bouwjaar = !empty($data['datum_eerste_toelating'])? gmdate('Y', strtotime($data['datum_eerste_toelating'])): 'N/A';
                    ?>
                        <tr>
                            <th scope="row" class="check-column">
                                <input type="checkbox" name="bulk_delete[]" value="<?php echo intval($row->id); ?>" title="Selecteer dit voertuig">
                            </th>
                            <td>
								<div class="row-actions">
									<a href="#" class="button button-small edit-vehicle" data-id="<?php echo esc_attr($row->id); ?>" title="Bewerken" aria-label="Voertuig bewerken">
										<span>✏️</span> Bewerken
									</a>
									<a href="#" class="button button-small delete-vehicle" data-id="<?php echo esc_attr($row->id); ?>" title="Verwijderen" aria-label="Voertuig verwijderen">
										<span>🗑️</span> Verwijderen
									</a>
									<?php if (function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()) : ?>
									<a href="#" class="button button-small create-post" data-id="<?php echo esc_attr($row->id); ?>" title="Zet online" aria-label="Zet online">
										<span>🌐</span> Zet online!
									</a>
									<?php else: ?>
										<span class="button button-small" style="opacity:.6; cursor:not-allowed;" title="Pro vereist">
											<span>🌐</span> Zet online!(Pro)
										</span>
									<?php endif; ?>
									<a href="?page=rdw-auto-info&rdw_duplicate=<?php echo intval($row->id); ?>" class="button button-small duplicate-vehicle" title="Dupliceer" aria-label="Dupliceer voertuig">
									<span>📑</span> Dupliceer
									</a>
								</div>
                            </td>
								<td><?php echo esc_html($row->kenteken); ?></td>
								<td><?php echo esc_html($data['merk'] ?? 'N/A'); ?></td>
								<td><?php echo esc_html($data['handelsbenaming'] ?? 'N/A'); ?></td>
							<!-- Verkocht status -->
							<td>
								<?php
								$verkocht = !empty($data['verkocht']) && $data['verkocht'] === '1';
								echo $verkocht ? '<span class="badge badge-sold">Ja</span>' : '<span class="badge badge-unsold">Nee</span>';
								?>
							</td>
							<!-- Bericht status -->
							<td>
								<?php
								$post_count = count(get_posts([
									'post_type'   => 'post',
									'post_status' => 'publish',
									'meta_query'  => [[
										'key'   => '_rdw_kenteken',
										'value' => $row->kenteken,
									]],
									'fields' => 'ids'
								]));

								if ($post_count > 0) {
									echo '<span class="badge badge-posts">' . esc_html( $post_count ) . '</span>';
								} else {
									echo '<span class="badge badge-nopost">Nee</span>';
								}
								if ($post_count > 1) {
									echo ' <span class="warning-icon" title="' . esc_attr('Meerdere berichten') . '">⚠️</span>';
								}
								?>
							</td>
							<td>
								<?php
								$featured_id = get_option('rdw_vehicle_featured_' . $row->id);
								$gallery_ids = get_option('rdw_vehicle_gallery_' . $row->id);
								$count = 0;
								if ($featured_id) { $count++; }
								if (is_array($gallery_ids)) { $count += count($gallery_ids); }

								if ($count > 0) {
									echo '<span class="badge badge-photos">' . esc_html( $count ) . ' ' . esc_html( $count > 1 ? 'foto’s' : 'foto' ) . '</span>';
								} else {
									echo '<em>' . esc_html( "Geen foto's" ) . '</em>';
								}
								?>
							</td>							
							<td><span class="badge badge-km"><?php echo esc_html($data['kilometers'] ?? 'N/A'); ?></span></td>
							<td><span class="badge badge-price"><?php echo esc_html($data['prijs'] ?? 'N/A'); ?></span></td>
							<td><span class="badge badge-year"><?php echo esc_html($bouwjaar); ?></span></td>
							<td>
								<?php
								$created = $row->created_at ?? '';
								echo $created ? esc_html( gmdate('d-m-Y H:i', strtotime($created)) ) : 'N/A';
								?>
							</td>
							<td>
								<?php
								$updated = $row->updated_at ?? '';
								echo $updated ? esc_html( gmdate('d-m-Y H:i', strtotime($updated)) ) : 'N/A';
								?>
							</td>
                            <td><?php echo esc_html(get_userdata($row->created_by)->display_name ?? 'N/A'); ?></td>
                            <td><?php echo esc_html(get_userdata($row->updated_by)->display_name ?? 'N/A'); ?></td>
                        </tr>

                        <!-- Inline bewerk-rij -->
                        <tr class="editable-fields" style="display: none;">
                            <td colspan="12">
                                <form method="post" action="<?php echo esc_url( admin_url('admin.php?page=rdw-auto-info') ); ?>" class="inline-form">
                                    <?php wp_nonce_field('rdw_update_selected','rdw_nonce_update'); ?>

                                    <ul>
                                        <?php foreach ($verkoopgegevens as $field): ?>
                                            <?php if (isset($data[$field])): ?>
                                                <li>
                                                    <input type="checkbox"
                                                           name="selected_data[]"
                                                           value="<?php echo esc_attr($field); ?>"
                                                           <?php echo isset($data[$field]) ? 'checked' : ''; ?>>
                                                    <strong><?php echo esc_html(ucfirst(str_replace('_', ' ', $field))); ?>:</strong>
                                                    <?php echo esc_html($data[$field]); ?>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>
									<hr>
                                    <input type="hidden" name="id" value="<?php echo esc_attr($row->id); ?>">
                                    <input type="hidden" name="kenteken" value="<?php echo esc_attr($row->kenteken); ?>">

                                    <label for="kilometers-<?php echo esc_attr($row->id); ?>">Kilometers:</label>
                                    <input type="text"
                                           name="kilometers"
                                           id="kilometers-<?php echo esc_attr($row->id); ?>"
                                           value="<?php echo esc_attr($data['kilometers'] ?? ''); ?>">

                                    <label for="prijs-<?php echo esc_attr($row->id); ?>">Prijs:</label>
                                    <input type="text"
                                           name="prijs"
                                           id="prijs-<?php echo esc_attr($row->id); ?>"
                                           value="<?php echo esc_attr($data['prijs'] ?? ''); ?>"><br><br>
									<label for="verkoper_tekst-<?php echo esc_attr($row->id); ?>">Verkoperstekst:</label><br>
										<textarea name="verkoper_tekst" id="verkoper_tekst-<?php echo esc_attr($row->id); ?>" rows="4" class="large-text"><?php 
											echo esc_textarea($data['verkoper_tekst'] ?? ''); ?></textarea>
									<hr>
									<label>
										<input type="checkbox" name="verkocht" value="1" <?php checked($data['verkocht'] ?? '', '1'); ?>>
										Verkocht
									</label>
									<h4>Foto's beheren</h4>

									<?php if (function_exists('rdw_is_pro_enabled') && rdw_is_pro_enabled()) : ?>
										<label>Uitgelichte foto:</label>
										<?php $cur_featured = get_option('rdw_vehicle_featured_' . $row->id); ?>
										<input type="hidden" name="featured_photo_id" id="featured_photo_id_<?php echo esc_html($row->id); ?>" value="<?php echo esc_attr($cur_featured); ?>">
										<button type="button" class="button select-featured-photo" data-target="<?php echo esc_attr($row->id); ?>">Kies uit Media Bibliotheek</button><br>
										<div id="featured-photo-preview_<?php echo esc_html($row->id); ?>">
											<?php if ($cur_featured) echo wp_get_attachment_image($cur_featured, 'thumbnail'); ?>
										</div>

										<label>Galerijfoto's:</label>
										<?php $cur_gallery = get_option('rdw_vehicle_gallery_' . $row->id) ?: []; ?>
										<input type="hidden" name="gallery_photo_ids" id="gallery_photo_ids_<?php echo esc_html($row->id); ?>" value="<?php echo esc_attr(implode(',', $cur_gallery)); ?>">
										<button type="button" class="button select-gallery-photos" data-target="<?php echo esc_attr($row->id); ?>">Kies meerdere uit Media Bibliotheek</button><br>
										<div id="gallery-photos-preview_<?php echo esc_html($row->id); ?>">
											<?php foreach ($cur_gallery as $gid) echo wp_get_attachment_image($gid, 'thumbnail'); ?>
										</div>	
									<?php else: ?>
										<em>Foto’s beheren is Pro. Activeer je licentie om deze sectie te gebruiken.</em>
									<?php endif; ?>
									
                                    <input type="submit" name="update_selected_data" value="Update selectie" class="button button-primary">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
              </table>
			</div>

            <button type="submit" name="bulk_delete_submit" class="button button-danger">Bulk verwijderen</button>
        </form>

        <!-- Centrale verborgen actieformulier (eenmalig) -->
        <form method="post" action="<?php echo esc_url( admin_url('admin.php?page=rdw-auto-info') ); ?>" id="rdw-action-form" style="display:none;">
            <?php
            wp_nonce_field('rdw_delete_vehicle','rdw_nonce_delete');
            wp_nonce_field('rdw_create_post','rdw_nonce_create');
            ?>
            <input type="hidden" name="id" value="">
            <input type="hidden" name="delete_vehicle" value="">
            <input type="hidden" name="create_post" value="">
        </form>

    <?php endif; ?>
</div>