<?php
class RDW_License {
    public static function get_key() {
        return trim(get_option('rdw_license_key', ''));
    }

    public static function get_status() {
        return get_option('rdw_license_status', '');
    }

    public static function is_valid() {
        return self::get_status() === 'valid';
    }

	public static function get_domain() {
		$home = home_url();
		$host = wp_parse_url($home, PHP_URL_HOST);
		return strtolower($host ?: $home);
	}

    public static function get_endpoint() {
        return 'https://www.onlineja.nl/wp-json/rdw-license/v1/validate';
    }

    public static function validate_remote($license) {
        $endpoint = self::get_endpoint();
        $domain   = self::get_domain();

        $body = [
            'license' => $license,
            'domain'  => $domain,
            'plugin'  => 'rdw-auto-info',
            'version' => '4.1',
        ];

        $response = wp_remote_post($endpoint, [
            'timeout'   => 15,
            'headers'   => ['Content-Type' => 'application/json'],
            'body'      => wp_json_encode($body),
            'sslverify' => true,
        ]);

        $now = time();
        $last_valid = get_option('rdw_license_last_valid', 0);

        if (is_wp_error($response)) {
            if ($last_valid && ($now - $last_valid) < 172800) {
                return get_option('rdw_license_status', '');
            }
            return '';
        }

        $code = wp_remote_retrieve_response_code($response);
        $json = json_decode(wp_remote_retrieve_body($response), true);

        if ($code === 200 && is_array($json) && !empty($json['status'])) {
            $status = sanitize_text_field($json['status']);
            update_option('rdw_license_status', $status, false);
            if ($status === 'valid') {
                update_option('rdw_license_last_valid', $now, false);
            }
            if (!empty($json['assigned_domain'])) {
                update_option('rdw_license_domain', sanitize_text_field($json['assigned_domain']), false);
            }
            return $status;
        }

        if ($last_valid && ($now - $last_valid) < 172800) {
            return get_option('rdw_license_status', '');
        }

        return '';
    }
}