<?php
// Helpers zonder sluitende PHP-tag (best practice)

if (!function_exists('rdw_format_price')) {
    function rdw_format_price($raw) {
        if ($raw === null) return '';
        // Normaliseer invoer (verwijder valuta/whitespace, zet komma -> punt)
        $norm = str_replace(['€', ' '], '', (string) $raw);
        $norm = str_replace(',', '.', $norm);
        $val = floatval($norm);
        return number_format($val, 2, ',', '.');
    }
}

function rdw_format_kilometers($raw) {
    if ($raw === null || $raw === '') return '';
    // Verwijder niet-numerieke tekens behalve cijfers
    $val = preg_replace('/[^0-9]/', '', $raw);
    return number_format((int)$val, 0, ',', '.');
}

if (!function_exists('rdw_format_date')) {
    function rdw_format_date($raw) {
        if (!$raw) return '';
        $ts = strtotime($raw);
        if (!$ts) return '';
        return function_exists('date_i18n')
            ? date_i18n(get_option('date_format'), $ts)
            : gmdate('Y-m-d', $ts);
    }
}


function rdw_duplicate_entry($id) {
    global $wpdb;
    $table_name = $wpdb->prefix . "rdw_auto_info";
    $row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);
    if ($row) {
        unset($row['id']);
        $row['created_at'] = current_time('mysql');
        $row['updated_at'] = current_time('mysql');
        $wpdb->insert($table_name, $row);
        $new_id = $wpdb->insert_id;

        if ($new_id > 0) {
            // Copy featured + gallery photo references
            $old_featured = get_option('rdw_vehicle_featured_' . $id);
            if ($old_featured) {
                update_option('rdw_vehicle_featured_' . $new_id, $old_featured, false);
            }
            $old_gallery = get_option('rdw_vehicle_gallery_' . $id);
            if (is_array($old_gallery) && !empty($old_gallery)) {
                update_option('rdw_vehicle_gallery_' . $new_id, $old_gallery, false);
            }
            return $new_id;
        }
        return false;
    }
    return false;
}
