<?php
require_once plugin_dir_path(__FILE__) . 'class-rdw-license.php';

function rdw_get_license_key() {
    return RDW_License::get_key();
}

function rdw_get_license_status() {
    return RDW_License::get_status();
}

function rdw_is_pro_enabled() {
    return RDW_License::is_valid();
}

function rdw_validate_license_remote($license) {
    return RDW_License::validate_remote($license);
}

function rdw_license_settings_page() {
    if (!current_user_can('manage_options')) {
        wp_die('Je hebt geen toegang tot deze pagina.');
    }

    // Forceer realtime validatie bij openen van de licentie-instellingen
    if (function_exists('rdw_get_license_key') && function_exists('rdw_validate_license_remote')) {
        $key = rdw_get_license_key();
        if (!empty($key)) {
            rdw_validate_license_remote($key);
        }
    }

		if (
			isset($_POST['rdw_license_submit'], $_POST['rdw_license_nonce']) &&
			wp_verify_nonce( wp_unslash($_POST['rdw_license_nonce']), 'rdw_license_action' )
		) {
			$key_raw = wp_unslash( $_POST['rdw_license_key'] ?? '' );
			$key     = sanitize_text_field( $key_raw );
			if (!preg_match('/^[A-Z0-9\-]{10,40}$/i', $key)) {
				echo '<div class="notice notice-error"><p>' . esc_html__('Ongeldige licentiecode. Gebruik alleen letters, cijfers en koppeltekens.', 'rdw-auto-info') . '</p></div>';
				return;
			}
			update_option('rdw_license_key', $key, false);

        if ($key) {
            $status = rdw_validate_license_remote($key);
            add_action('admin_notices', function() use ($status) {
                echo '<div class="notice notice-info is-dismissible"><p>Licentie status: ' . esc_html($status ?: 'onbekend') . '</p></div>';
            });
        } else {
            update_option('rdw_license_status', '', false);
            delete_option('rdw_license_domain');
            add_action('admin_notices', function() {
                echo '<div class="notice notice-warning is-dismissible"><p>Licentiesleutel verwijderd.</p></div>';
            });
        }
    }

		$current_key    = RDW_License::get_key();
		$current_status = RDW_License::get_status();
		$current_domain = get_option('rdw_license_domain', '');
		$last_valid     = (int) get_option('rdw_license_last_valid', 0);
		$now            = time();
		$age            = $now - $last_valid;

		echo '<div class="wrap"><h1>' . esc_html__('RDW Licentie', 'rdw-auto-info') . '</h1>';
		echo '<form method="post">';
		wp_nonce_field('rdw_license_action','rdw_license_nonce');

		echo '<table class="form-table"><tbody>';
		echo '<tr><th scope="row">' . esc_html__('Licentiesleutel', 'rdw-auto-info') . '</th><td>';
		echo '<input type="text" name="rdw_license_key" value="' . esc_attr( $current_key ) . '" class="regular-text" />';
		echo '<p class="description">' . esc_html__('Voer je licentiecode in (1 site per licentie).', 'rdw-auto-info') . '</p>';
		echo '</td></tr>';

		echo '<tr><th scope="row">' . esc_html__('Status', 'rdw-auto-info') . '</th><td>';
		if ($current_status === 'valid' && $age > 172800) {
			echo '<code>' . esc_html__('Onbekend', 'rdw-auto-info') . ' (' . esc_html( gmdate('d-m-Y H:i', $last_valid) ) . ', ' . esc_html__('Neem contact op: contact@onlineja.nl', 'rdw-auto-info') . ')</code>';
		} else {
			echo '<code>' . esc_html( $current_status ?: '—' ) . '</code>';
		}
		if ($current_domain) {
			echo ' (' . esc_html__('toegewezen aan:', 'rdw-auto-info') . ' ' . esc_html( $current_domain ) . ')';
		}
		echo '</td></tr>';
		echo '</tbody></table>';

		echo '<p><input type="submit" name="rdw_license_submit" class="button button-primary" value="' . esc_attr__('Opslaan & Valideren', 'rdw-auto-info') . '"></p>';
		echo '</form></div>';
}