jQuery(function ($) {
    function getCheckboxes() { return $('input[name="bulk_delete[]"]'); }
    function getBulkButton() { return $('button[name="bulk_delete_submit"]'); }
    function getActionForm() { return $('#rdw-action-form'); }
	// Helper voor de checkboxes in het nieuwe voertuig-formulier
	function getNewVehicleCheckboxes() {return $('#new-vehicle-data input[name="selected_data[]"]');}

    // Edit toggle
    $(document).on('click', '.edit-vehicle', function (e) {
        e.preventDefault();
        $(this).closest('tr').next('.editable-fields').toggle();
    });

    // Bulk delete knop tonen/verbergen
    function updateBulkButton() {
        const $checkboxes = getCheckboxes();
        const $button = getBulkButton();
        if (!$button.length) return;
        const anyChecked = $checkboxes.filter(':checked').length > 0;
        if (anyChecked) { $button.show(); } else { $button.hide(); }
    }
    $(document).on('change', 'input[name="bulk_delete[]"]', updateBulkButton);
    updateBulkButton();

    // Delete via centrale form
    $(document).on('click', '.delete-vehicle', function (e) {
        e.preventDefault();
        const id = $(this).data('id');
        const $form = getActionForm();
        if (!$form.length || !id) return;
        if (window.confirm('Weet je zeker dat je dit voertuig wilt verwijderen?')) {
            $form.find('input[name="id"]').val(id);
            $form.find('input[name="delete_vehicle"]').val('1').prop('disabled', false);
            $form.find('input[name="create_post"]').prop('disabled', true);
            $form.trigger('submit');
        }
    });

    // Create post via centrale form
    $(document).on('click', '.create-post', function (e) {
        e.preventDefault();
        const id = $(this).data('id');
        const $form = getActionForm();
        if (!$form.length || !id) return;
        $form.find('input[name="id"]').val(id);
        $form.find('input[name="create_post"]').val('1').prop('disabled', false);
        $form.find('input[name="delete_vehicle"]').prop('disabled', true);
        $form.trigger('submit');
    });

	// Select all / deselect all voor nieuwe voertuig-data
	$('#select-all-new').on('click', function () {
		getNewVehicleCheckboxes().prop('checked', true).trigger('change');
	});
	$('#deselect-all-new').on('click', function () {
		getNewVehicleCheckboxes().prop('checked', false).trigger('change');
	});

    // Fallback select-all checkbox
    const $selectAll = $('#select-all');
    if ($selectAll.length) {
        $selectAll.on('click', function () {
            const checked = $(this).prop('checked');
            getCheckboxes().prop('checked', checked).trigger('change');
        });
    }
});
// Media Bibliotheek selectors
jQuery(function($){
    let featuredFrame, galleryFrame;

    $('#select-featured-photo').on('click', function(e){
        e.preventDefault();
        if (featuredFrame) { featuredFrame.open(); return; }
        featuredFrame = wp.media({
            title: 'Kies uitgelichte foto',
            button: { text: 'Gebruik deze foto' },
            multiple: false
        });
        featuredFrame.on('select', function(){
            const attachment = featuredFrame.state().get('selection').first().toJSON();
            $('#featured_photo_id').val(attachment.id);
            $('#featured-photo-preview').html('<img src="'+attachment.sizes.thumbnail.url+'" />');
        });
        featuredFrame.open();
    });

    $('#select-gallery-photos').on('click', function(e){
        e.preventDefault();
        if (galleryFrame) { galleryFrame.open(); return; }
        galleryFrame = wp.media({
            title: 'Kies galerijfoto\'s',
            button: { text: 'Gebruik deze foto\'s' },
            multiple: true
        });
        galleryFrame.on('select', function(){
            const ids = [];
            const previews = [];
            galleryFrame.state().get('selection').each(function(att){
                const a = att.toJSON();
                ids.push(a.id);
                previews.push('<img src="'+a.sizes.thumbnail.url+'" />');
            });
            $('#gallery_photo_ids').val(ids.join(','));
            $('#gallery-photos-preview').html(previews.join(''));
        });
        galleryFrame.open();
    });
});

// Inline edit: Media Bibliotheek
jQuery(function($){
    $(document).on('click', '.select-featured-photo', function(e){
        e.preventDefault();
        const rowId = $(this).data('target');
        const $hid = $('#featured_photo_id_' + rowId);
        const $prev = $('#featured-photo-preview_' + rowId);

        const frame = wp.media({ title: 'Kies uitgelichte foto', button: { text: 'Gebruik deze foto' }, multiple: false });
        frame.on('select', function(){
            const attachment = frame.state().get('selection').first().toJSON();
            $hid.val(attachment.id);
            $prev.html('<img src="'+attachment.sizes.thumbnail.url+'" />');
        });
        frame.open();
    });

    $(document).on('click', '.select-gallery-photos', function(e){
        e.preventDefault();
        const rowId = $(this).data('target');
        const $hid = $('#gallery_photo_ids_' + rowId);
        const $prev = $('#gallery-photos-preview_' + rowId);

        const frame = wp.media({ title: 'Kies galerijfoto\'s', button: { text: 'Gebruik deze foto\'s' }, multiple: true });
        frame.on('select', function(){
            const ids = [];
            const previews = [];
            frame.state().get('selection').each(function(att){
                const a = att.toJSON();
                ids.push(a.id);
                previews.push('<img src="'+(a.sizes?.thumbnail?.url || a.url)+'" />');
            });
            $hid.val(ids.join(','));
            $prev.html(previews.join(''));
        });
        frame.open();
    });
});


// === RDW Auto Info: kolomsortering ===
jQuery(function($){
    const table = $('.wp-list-table');
    if (!table.length) return;

    const tbody = table.find('tbody');
    const headers = table.find('thead th');

    // Voeg UI indicatie toe
    headers.each(function(){
        const type = $(this).data('sort');
        if (type && type !== 'none') {
            $(this).addClass('rdw-sortable').append(' ▾'); // UI hint
        }
    });

    function parseCellText($td) {
        return ($td.text() || '').trim();
    }

    function parseNumber(text) {
        // Haal digits uit bv "12 foto’s", "€ 10.000"
        const clean = text.replace(/[^\d.,-]/g, '').replace(/\./g, '').replace(',', '.');
        const num = parseFloat(clean);
        return isNaN(num) ? 0 : num;
    }

    function parseDate(text) {
        // Verwacht formaat: dd-mm-yyyy HH:MM
        // Converteer naar Date: yyyy-mm-ddTHH:MM
        const m = text.match(/^(\d{2})-(\d{2})-(\d{4})\s+(\d{2}):(\d{2})$/);
        if (!m) return 0;
        const iso = `${m[3]}-${m[2]}-${m[1]}T${m[4]}:${m[5]}:00`;
        const d = new Date(iso);
        return d.getTime() || 0;
    }

    let sortState = { index: -1, dir: 'asc' };

    headers.on('click', function(){
        const type = $(this).data('sort');
        if (!type || type === 'none') return;

        const index = $(this).index();
        // toggle sort direction if same column
        if (sortState.index === index) {
            sortState.dir = sortState.dir === 'asc' ? 'desc' : 'asc';
        } else {
            sortState.index = index;
            sortState.dir = 'asc';
        }

        // verzamel rijen (exclusief inline edit-rijen)
        const rows = tbody.find('tr').filter(function(){
            return !$(this).hasClass('editable-fields');
        }).get();

        rows.sort(function(a, b){
            const $a = $(a).children('td, th').eq(index);
            const $b = $(b).children('td, th').eq(index);
            let va = parseCellText($a);
            let vb = parseCellText($b);

            let cmp = 0;
            if (type === 'number') {
                cmp = parseNumber(va) - parseNumber(vb);
            } else if (type === 'date') {
                cmp = parseDate(va) - parseDate(vb);
            } else {
                // text (case-insensitive)
                cmp = va.localeCompare(vb, undefined, { sensitivity: 'base' });
            }
            return sortState.dir === 'asc' ? cmp : -cmp;
        });

        // herplaats rijen (behoud inline edit-rij direct erna)
        tbody.empty();
        rows.forEach(function(row){
            const $row = $(row);
            tbody.append($row);
            // indien volgende rij editable-fields bij dezelfde entry hoort, zet mee terug
            const $next = $row.next('.editable-fields');
            if ($next.length) {
                tbody.append($next);
            }
        });

        // UI: update pijltje
        headers.removeClass('rdw-sort-asc rdw-sort-desc');
        $(this).addClass(sortState.dir === 'asc' ? 'rdw-sort-asc' : 'rdw-sort-desc');
    });
});